$(document).ready(async function () {

  criaDataTablePadrao('#tabelaValoresMetas', false, false, false, false, true, false, false, null, null, []);
  criaDataTablePadrao('#tabelaOpcoesMetas', false, false, false, false, true, false, false, null, null, [], [5, 6]);
  criaDataTablePadrao('#tabelaMetas', false, false, false, false, true, false, false, null, null, [], [4, 5]);
  if ($('#tabelaMetas').DataTable().rows().count() < 6) {
    $('#tabelaMetas').css('min-height', '80px');
  }

  componenteFiltro('empresa', true, true);
  componenteFiltro('vendedor', true, true);
  componenteFiltro('produto', true, true);
  componenteFiltro('material', true, true);
  componenteFiltro('colecao', true, true);
  componenteFiltro('grupo', true, true);
  componenteFiltro('cliente', true, true);

  $("#txtValorMeta").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $("#txtPercentual").maskMoney({
    decimal: ".",
    thousands: "",
    precision: 2,
  });

  $('#check_todos').on('change', function () {
    $('.campoSel').prop('checked', $('#check_todos').prop('checked'));
    if ($('#check_todos').prop('checked')) {
      $('.campoSel').addClass('selecionado');
    } else {
      $('.campoSel').removeClass('selecionado');
    }
  });

  $("#txtPercentual").on('blur', function () {
    if ($(this).val() > 100) {
      $(this).val("0.00");
    }
  })

  $('#btnGravarMeta').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const Meta = new Metas($('#txtSelectTipos').val(), $('#txtNomeMeta').val(), `${$('#txtDtInicial').val()}T00:00:00Z`, `${$('#txtDtFinal').val()}T00:00:00Z`);
      if (Meta.validar()) {
        Meta.gravar();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnEditarMeta').on('click', async function () {
    $('#txtDtFinalOpcoes').prop('disabled', false);
    $('#txtDtInicialOpcoes').prop('disabled', false);
    $('#txtDescricaoMeta').prop('disabled', false);
    $('#btnEditarMeta').addClass('d-none');
    $('#btnGravarEditacaoMeta').removeClass('d-none');
    $('#btnCancelarEdicao').removeClass('d-none');
  })

  $('#btnGravarEditacaoMeta').on('click', async function () {
    try {
      $.LoadingOverlay('show');

      const Meta = new Metas($('#txtTipoDaMeta').val(), $('#txtDescricaoMeta').val(), `${$('#txtDtInicialOpcoes').val()}T00:00:00Z`, `${$('#txtDtFinalOpcoes').val()}T00:00:00Z`, $('#txtIdMeta').val());
      Meta.editar();


    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');

      $('#btnGravarEditacaoMeta').addClass('d-none');
      $('#btnCancelarEdicao').addClass('d-none');
      $('#btnEditarMeta').removeClass('d-none');
    }
  });

  $('#btnCancelarEdicao').on('click', async function () {

    $('#txtDtFinalOpcoes').prop('disabled', true);
    $('#txtDtInicialOpcoes').prop('disabled', true);
    $('#txtDescricaoMeta').prop('disabled', true);
    $('#btnEditarMeta').removeClass('d-none');
    $('#btnGravarEditacaoMeta').addClass('d-none');
    $('#btnCancelarEdicao').addClass('d-none');
  });

  $('#btnGravarMetaLOJA').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtEmpresa').val(), $('#txtIdMeta').val());
      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaVENDEDOR').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtVendedor').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaPRODUTO').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtProduto').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaMATERIAL').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtMaterial').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaCOLECAO').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtColecao').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaGRUPO').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtGrupo').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#btnGravarMetaCLIENTE').on('click', async function () {
    try {
      $.LoadingOverlay('show');
      const metasOpcoes = new OpcoesMetas($('#txtValorMeta').val(), $('#txtOperacaoMeta').val(), $('#txtPercentual').val(), $('#txtCliente').val(), $('#txtIdMeta').val());

      if (metasOpcoes.validar()) {
        metasOpcoes.gravarOpcoes();
      }

      limpaCampos();
    } catch (error) {
      console.error(error);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#cbTodos').on('change', async function () {
    if (!isChecked('#cbTodos')) {
      $('#txtVendedor').empty().trigger('change');
      // $('#txtVendedor').select2();
      return;
    }

    const pesquisaParam = {
      tabela: 'REPRESEN',
      camposSelect: ['CODREP', 'NOME'],
      where: []
    }

    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));
    await insereValorPesquisaVarios('txtVendedor', 'CODREP', 'NOME', jsonStr);
    $('#txtVendedor').trigger('change');
    $('.txtVendedor').trigger('click');
    $('.txtVendedor').trigger('click');
  });

  $('#btnExplodir').on('click', function () {
    $('#modalDiasMeta').modal('show');
  });

  $('#btnVincularDias').on('click', function () {
    $('#modalVincularDiasMeta').modal('show');
  });

  $('#btnConfirmarDias').on('click', function () {
    $('#modalDiasMeta').modal('hide');
  });

  $('#modalVincularDiasMeta').on('shown.bs.modal', function () {
    $("#tabelaVincularDiasMeta").DataTable().columns.adjust().draw(false);
    $('#modalDiasValor').modal('hide')
  });
  $('#modalDiasMeta').on('shown.bs.modal', function () {
    $("#tabelaDiasMeta").DataTable().columns.adjust().draw(false);
  });

  $('#modalDiasValor').on('shown.bs.modal', function () {
    $("#tabelaDiasValor").DataTable().columns.adjust().draw(false);
  });

  $('#btnExplodir').on('click', function () {
    $("#tabelaDiasMeta").DataTable().rows().data().map((item, index) => {
      $($('.campoSel')[index]).prop('checked', item.DIA_UTIL == 'S');
    });
  });

  $('#btnSelecionarEmpresas').on('click', async function () {
    await carregaEmpresasDisponiveis();
  });

  $('#btnConfirmarEdicaoValorMeta').on('click', async function () {
    const obj = {
      Operacao: 0,
      Valor: TruncaDecimaisNova(2, $('#txtValorEditadoMeta').val()),
      Item: [],
      Id: $('#txtIdValorEditadoMeta').val(),
      Percentual: 0,
      Dias: [],
      Empresas: '',
    }
    const response = await requisicao('PUT', '/sisplan/metas/v1/opcoes?', ``, JSON.stringify(obj));

    if (!response) {
      return;
    }

    if (response.status != 200) {
      const jsonStr = await response.json();
      msgErro(jsonStr.mensagem);
      return;
    }
    criaMensagemSucesso('Valor da meta editado com sucesso!');

    const metas = new Metas($('#txtTipoDaMeta').val(), $('#txtDescricaoMeta').val(), $('#txtDtInicialOpcoes').val(), $('#txtDtFinalOpcoes').val(), $('#txtIdMeta').val()); 

    metas.carregaValoresMeta();

    $('#modal-EditarMeta').modal('hide');

  });

  function limpaCampos() {
    $('#txtNomeMeta').val('');
    $('#txtSelectTipos').val('');
    $('#txtDtInicial').val('');
    $('#txtDtFinal').val('');
    $('#txtOperacaoMeta').val('');
    $('#txtPercentual').val('')
    $('#txtValorMeta').val('0');
    $('#txtEmpresa').val('');
    $('#txtEmpresa').trigger('change');
    $('#txtVendedor').val('');
    $('#txtVendedor').trigger('change');
    $('#txtProduto').val('');
    $('#txtProduto').trigger('change');
    $('#txtMaterial').val('');
    $('#txtMaterial').trigger('change');
    $('#txtColecao').val('');
    $('#txtColecao').trigger('change');
    $('#txtGrupo').val('');
    $('#txtGrupo').trigger('change');
    $('#txtCliente').val('');
    $('#txtCliente').trigger('change');
    $('#txtClassificacaoCliente').val('');
  }


  $('#btnAdicionarClientesClassificacao').on('click', async function () {
    $.LoadingOverlay('show');
    try {

      const c = $('#txtClassificacaoCliente').val();

      if ((c == '') || (!c)) {
        msgErro('Favor selecionar uma classificação.');
        return;
      }

      new Metas().adicionarClientesClassificacao();

      $('#txtCliente').trigger('change');
      $('.txtCliente').trigger('click');
      $('.txtCliente').trigger('click');
    } catch (e) {
      console.error(e);
      msgErro(`Não foi possível buscar os clientes: ${e}`);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  new Metas().buscar();

  $('#tutorial').on('click', function () {
    const driver = new Driver({
      doneBtnText: 'Sair',
      closeBtnText: 'Fechar',
      nextBtnText: 'Próximo',
      prevBtnText: 'Anterior',
      allowClose: false,
      animate: true,
    });
    driver.defineSteps([{
      element: '#gravarCampos',
      popover: {
        title: 'Dados Gerais',
        description: 'Aqui estão os campos disponíveis para gravar a capa da Meta!.',
        position: 'rigth'
      }
    },
    {
      element: '#txtNomeMeta',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtSelectTipos',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'bottom'
      }
    },
    {
      element: '#txtDtInicial',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#txtDtFinal',
      popover: {
        title: 'Campos Obrigatórios',
        description: 'Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.',
        position: 'top'
      }
    },
    {
      element: '#btnGravarMeta',
      popover: {
        title: 'Botão Gravar',
        description: 'Clique aqui para gravar a meta!',
        position: 'left'
      }
    },
    {
      element: '#tabelaTour',
      popover: {
        title: 'Tabela de Metas',
        description: 'Aqui estarão todas as metas cadastradas!',
        position: 'top'
      }
    }
    ]);
    driver.start();
  });

}); 